/** @file   cgamebase.cpp
 * @brief   Implementation of CGameBase - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "cgamebase.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================

/** Constructor
 */
CGameBase::CGameBase() :
  iMaxFrameSkips( 6 ),
  iErrorMessage( "" )
{
}



/** Destructor
 */
CGameBase::~CGameBase()
{
}




///
/// Public methods
/// ==============

/** Inits this instance of game.
 */
int CGameBase::init()
{
  return this->initialize();
}



/** Runs the game
 */
int CGameBase::run()
{
  int frameSkip = 0;
  bool needsRedraw = false;
  FpsTimer* gameTimer = FpsTimer::getInstance();
  
  while ( this->endNow() == 0 ) {
    frameSkip = 0;
    if ( gameTimer->updatesToGo() > 0 ) {
      do {
        this->update();
        
        gameTimer->updateDone();
        frameSkip += 1;
        if ( frameSkip >= iMaxFrameSkips ) {
          gameTimer->reset();
          break;
        }
      } while ( gameTimer->updatesToGo() > 0 );
      needsRedraw = true;
    }
    
    if ( needsRedraw == true ) {
      this->redraw();
    }
  }
  return this->endNow();
}



/** Cleans up
 */
void CGameBase::flush()
{
  this->cleanup();
}




///
/// Getter methods
/// ==============

/** Returns the error message.
 */
std::string CGameBase::getErrorMessage() const
{
  return iErrorMessage;
}




///
/// Private or Protected methods
/// ============================

/** Sets the error message
 */
void CGameBase::setErrorMessage( const std::string& aMessage )
{
  iErrorMessage += aMessage += string( "\n" );
}


} // end of namespace
